* ==============================================================================
* Script:  3_descriptives.do
* Purpose: a. Used to produce the descriptive statistics in the paper
*		   b. Used to present all Figures in the paper   
* ==============================================================================
cd "$translog_gvty\processed"

* 1. Summary statistics (Table 1)
* =====================
  sutex dsps rta ltariff share n2_it v
	
* 2. Mean effects and effects at percentiles (repeat for each estimation)
* ==========================================

  reghdfe s_ijt dsps ltariff rta if s_ijt>0, absorb(jt it ij) cluster(id)
  gen elasticity = ((_b[dsps]) / s_ijt) 
  drop if elasticity ==. 
  egen p30 = pctile(s_ijt), p(30)
  egen p50 = pctile(s_ijt), p(50)
  egen p90 = pctile(s_ijt), p(90)
  egen mean_sh = mean(s_ijt)
		
  gen elasticities30   = (_b[dsps]) / p30
  gen elasticities50   = (_b[dsps]) / p50
  gen elasticities90   = (_b[dsps]) / p90
  gen elasticitiesMean = (_b[dsps]) / mean_sh
  
  sum elastici* // These are the elasticities reported at the bottom of each regression table
  drop p* mean_sh elasticit*
  

* 2. Descriptives
* ===============
  preserve
  reghdfe s_ijt dsps ltariff rta if s_ijt>0, absorb(jt it ij) cluster(id)
  *ppmlhdfe s_ijt dsps ltariff rta, absorb(jt it ij) cluster(id)
  *gen share = s_ijt * 100
  drop if dsps == 0
  drop if s_ijt == 0
  bys i j: egen new2 = sum(sps)
  drop if new2 == 0
  gen elasticity = ((_b[dsps]) / s_ijt)
	
  order i j t v share elasticity
  sort share
  keep i j t v share s_ijt  elasticity
  keep if j == "EU15" & t == 2017
  *collapse elasticities s_ijt, by(i j t)
  *graph twoway scatter elasticities s_ijt if j == "EU15"  & t  == 2010  & s_ijt>0.6
	
  egen p10 = pctile(s_ijt), p(10) 
  egen p15 = pctile(s_ijt), p(15)
  egen p20 = pctile(s_ijt), p(20)
  egen p25 = pctile(s_ijt), p(25)
  egen p30 = pctile(s_ijt), p(30)
  egen p35 = pctile(s_ijt), p(35)
  egen p40 = pctile(s_ijt), p(40)
  egen p45 = pctile(s_ijt), p(45)
  egen p50 = pctile(s_ijt), p(50)
  egen p55 = pctile(s_ijt), p(55)
  egen p60 = pctile(s_ijt), p(60)
  egen p65 = pctile(s_ijt), p(65)
  egen p70 = pctile(s_ijt), p(70)
  egen p75 = pctile(s_ijt), p(75)
  egen p80 = pctile(s_ijt), p(80)
  egen p85 = pctile(s_ijt), p(85)
  egen p90 = pctile(s_ijt), p(90)


centile s_ijt, centile(10(5)90) 

gen elasticities10 = (_b[dsps]) / p10
gen elasticities15 = (_b[dsps]) / p15
gen elasticities20 = (_b[dsps]) / p20
gen elasticities25 = (_b[dsps]) / p25
gen elasticities30 = (_b[dsps]) / p30
gen elasticities35 = (_b[dsps]) / p35
gen elasticities40 = (_b[dsps]) / p40
gen elasticities45 = (_b[dsps]) / p45
gen elasticities50 = (_b[dsps]) / p50
gen elasticities55 = (_b[dsps]) / p55
gen elasticities60 = (_b[dsps]) / p60
gen elasticities65 = (_b[dsps]) / p65
gen elasticities70 = (_b[dsps]) / p70
gen elasticities75 = (_b[dsps]) / p75
gen elasticities80 = (_b[dsps]) / p80
gen elasticities85 = (_b[dsps]) / p85
gen elasticities90 = (_b[dsps]) / p90

gen elasticities10ul = (_b[dsps]) / .0002473
gen elasticities15ul = (_b[dsps]) / .0005435
gen elasticities20ul = (_b[dsps]) / .0010642
gen elasticities25ul = (_b[dsps]) / .0017488
gen elasticities30ul = (_b[dsps]) / .0026019
gen elasticities35ul = (_b[dsps]) / .003752
gen elasticities40ul = (_b[dsps]) / .0051746
gen elasticities45ul = (_b[dsps]) / .0073258
gen elasticities50ul = (_b[dsps]) / .0101216
gen elasticities55ul = (_b[dsps]) / .0143043
gen elasticities60ul = (_b[dsps]) / .0196982
gen elasticities65ul = (_b[dsps]) / .0267714
gen elasticities70ul = (_b[dsps]) / .0345076
gen elasticities75ul = (_b[dsps]) / .0457166
gen elasticities80ul = (_b[dsps]) / .0637082
gen elasticities85ul = (_b[dsps]) / .0894186
gen elasticities90ul = (_b[dsps]) / .1332771

gen elasticities10ll = (_b[dsps]) / .0002042
gen elasticities15ll = (_b[dsps]) / .0004582
gen elasticities20ll = (_b[dsps]) / .000917
gen elasticities25ll = (_b[dsps]) / .0015427
gen elasticities30ll = (_b[dsps]) / .0023009
gen elasticities35ll = (_b[dsps]) / .0033684
gen elasticities40ll = (_b[dsps]) / .004648
gen elasticities45ll = (_b[dsps]) / .006508
gen elasticities50ll = (_b[dsps]) / .0091271 
gen elasticities55ll = (_b[dsps]) / .0126054 
gen elasticities60ll = (_b[dsps]) / .0177754
gen elasticities65ll = (_b[dsps]) / .0243783
gen elasticities70ll = (_b[dsps]) / .0315568
gen elasticities75ll = (_b[dsps]) / .0420176
gen elasticities80ll = (_b[dsps]) / .0577755
gen elasticities85ll = (_b[dsps]) / .0809327
gen elasticities90ll = (_b[dsps]) / .1217579

keep elasticiti*
duplicates drop 

* I take this values into R and generate Figure 1
restore

* Number of countries targeted by at least one SPS concern across t
drop if sps == 0
bys i t: gen newi = _n
keep t newi
duplicates drop
bys t: egen new = max(newi)

* Figure A1
* =========
use translog_gravity, clear
  gen byte dsps = sps > 0
  preserve 
* Number of countries raising or maintaining SPS related concerns  
* Concerned countries
  keep if dsps == 1
  keep i t dsps
  duplicates drop 
  bys t: egen concern = sum(dsps) 
  keep t concern
  duplicates drop 
  sort t 
  save concern, replace 
  
  restore
* Maintaining countries
  keep if dsps == 1
  keep j t dsps
  duplicates drop 
  bys t: egen maintain = sum(dsps) 
  keep t maintain
  duplicates drop 
  sort t 
  merge 1:m t using concern, nogen
 

* Figure A2
* =========
use translog_gravity, clear
  gen byte dsps = sps > 0
  preserve 
* Number of times a country complained about a measure you maintained 
  keep if dsps == 1
  keep i t dsps sps
  duplicates drop 
  *keep the EU as a group
  drop if (i=="FRA" |i=="ITA" |i=="NLD" |i=="BEL"| i=="BLX" |i=="LUX" |i=="GBR" |i=="DNK" |i=="IRL"|i=="ESP" |i=="PRT" |i=="GRC"  |i=="AUT" |i=="SWE" |i=="FIN")
foreach c in HUN LVA LTU POL SVK SVN CZE EST CYP MLT{
  drop if i == "`c'" & t >=2004
}
 replace i = "EU15" if i == "DEU"
 drop if i == "BGR" & t >= 2007
 drop if i == "ROU" & t >= 2007
 drop if i == "HRV" & t >= 2013
 drop t
 duplicates drop
 bys i: egen concern  = sum(dsps) 
 keep i  concern 
 duplicates drop
 sort concern
 rename i iso
 save concern, replace
 
 restore
 * Number of countries that raised a concern
  keep if dsps == 1
  keep j t dsps sps
  duplicates drop 
  *keep the EU as a group
foreach c in HUN LVA LTU POL SVK SVN CZE EST CYP MLT{
  drop if j == "`c'" & t >=2004
}
 drop if j == "BGR" & t >= 2007
 drop if j == "ROU" & t >= 2007
 drop if j == "HRV" & t >= 2013
 drop t
 duplicates drop
 bys j: egen maintain  = sum(dsps) 
 keep j  maintain 
 duplicates drop
 sort maintain
 rename j iso
 
 merge 1:m iso using concern, keep(3) nogen 
 merge 1:m iso using ccode, keep (1 3) nogen
 replace name = "EU" if iso == "EU15"
 replace name = "Taiwan" if iso == "TWN"
 replace name = "South Africa" if name == "So. African Customs Union"
export delimited using "C:\Users\dfianko\ownCloud\R graphs\stc2.csv", replace